/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_3f_h__
#define __REG_3f_h__

/* ***********************************************************************
   *                                                                     *
   * regx3f.h                                                            *
   * Christoph Schmidt, BID R&D, 9.7.98                                  *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"   /* contains CMD_MERGE and CMDG_PROTOCOLSET_0 */


#define MERGE_TCGET_0(cmd)	CMD_MERGE (CMDG_TCGET_0, cmd)


#define CMDM_TCMASK_GET	0x05
#define CMD_TCMASK_GET		MERGE_TCGET_0 (CMDM_TCMASK_GET)
#define IN_TCMASK_GET		 2   /* signal position and length */
#define OUT_TCMASK_GET		 4   /* mask  */

#define CMDM_TCPROP_GET	0x06
#define CMD_TCPROP_GET		MERGE_TCGET_0 (CMDM_TCPROP_GET)
#define IN_TCPROP_GET		 1   
#define OUT_TCPROP_GET		 4  

#define CMDM_TCPROP_READ	0x07
#define CMD_TCPROP_READ		MERGE_TCGET_0 (CMDM_TCPROP_READ)
#define IN_TCPROP_READ		 0   
#define OUT_TCPROP_READ		 0

#define CMDM_TCGENPROP_GET	0x09
#define CMD_TCGENPROP_GET		MERGE_TCGET_0 (CMDM_TCGENPROP_GET)
#define IN_TCGENPROP_GET		 1   
#define OUT_TCGENPROP_GET		 4  

#endif
